/*
 * Decompiled with CFR 0.152.
 */
package emulator.assembler;

import emulator.assembler.Assembler;
import emulator.assembler.DataDescriptionTable;
import emulator.assembler.Instruction;
import java.util.HashSet;
import java.util.LinkedList;

public class CodeAnalyzer {
    private Assembler assembler;
    private DataDescriptionTable data_table;
    private byte[] memory;
    private LinkedList<Integer> address_list;
    private HashSet<Integer> visited_addresses;

    public CodeAnalyzer(Assembler assembler, DataDescriptionTable data_table, byte[] memory, LinkedList<Integer> address_list) {
        this.assembler = assembler;
        this.data_table = data_table;
        this.memory = memory;
        this.address_list = address_list;
        this.visited_addresses = new HashSet();
    }

    public void runAnalysis() {
        while (this.address_list.size() > 0) {
            int address = this.address_list.pop();
            if (this.visited_addresses.contains(address)) continue;
            try {
                while (address < this.memory.length) {
                    this.visited_addresses.add(address);
                    Instruction instruction = this.assembler.getInstruction(this.memory, address);
                    this.registerInstruction(address, instruction);
                    if (!instruction.isEnd()) {
                        address += instruction.getByteCount();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.getMessage();
            }
            for (Integer target : this.assembler.getSymbols().getJumpTargets()) {
                if (this.visited_addresses.contains(target)) continue;
                this.address_list.push(target);
            }
        }
        this.data_table.reindex();
    }

    private void registerInstruction(int address, Instruction instruction) {
        this.data_table.insertInstruction(address, instruction);
    }
}

